/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.blockentities;

import com.alexander.mutantmore.blocks.HeatstormGeneratorBlock;
import com.alexander.mutantmore.config.HeatstormGeneratorCommonConfig;
import com.alexander.mutantmore.init.BlockEntityTypeInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.interfaces.IHeatSource;
import com.alexander.mutantmore.util.HandleLoopingSoundInstances;
import com.alexander.mutantmore.util.HeatUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class HeatstormGeneratorBlockEntity
extends BlockEntity
implements IAnimatable,
IHeatSource {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public boolean playingSoundLoop = false;
    public int expectedSoundUpdateTime;
    public RandomSource random = RandomSource.m_216327_();

    public HeatstormGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypeInit.HEATSTORM_GENERATOR.get(), pos, state);
    }

    private <E extends BlockEntity> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("heatstorm_generator_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public double heatRange() {
        return this.shouldHeat() ? (Double)HeatstormGeneratorCommonConfig.heat_range.get() : 0.0;
    }

    @Override
    public double heatRangeY() {
        return this.shouldHeat() ? (Double)HeatstormGeneratorCommonConfig.heat_range_y.get() : 0.0;
    }

    public boolean shouldHeat() {
        return (Boolean)this.m_58900_().m_61143_((Property)HeatstormGeneratorBlock.POWERED);
    }

    @Override
    public boolean canHeat(LivingEntity heatTarget) {
        if (heatTarget.m_6095_().m_204039_(TagInit.EntityTypes.CANT_BE_HEATED)) {
            return false;
        }
        if (heatTarget.m_6095_().m_204039_(TagInit.EntityTypes.HEATSTORM_GENERATOR_CANT_HEAT)) {
            return false;
        }
        if (heatTarget.m_5825_() && !((Boolean)HeatstormGeneratorCommonConfig.heats_fire_immune_mobs.get()).booleanValue()) {
            return false;
        }
        if (heatTarget.m_5833_()) {
            return false;
        }
        return !(heatTarget instanceof Player) || !((Player)heatTarget).m_7500_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HeatstormGeneratorBlockEntity object) {
        BlockPos blockPos;
        if (level.f_46443_) {
            HandleLoopingSoundInstances.tickHeatstormGeneratorAudio(object, level);
        }
        if (!level.f_46443_ && ((Boolean)HeatstormGeneratorCommonConfig.heat_griefing.get()).booleanValue() && object.shouldHeat() && object.random.m_188503_(((Integer)HeatstormGeneratorCommonConfig.heat_griefing_chance.get()).intValue()) == 0 && level.m_8055_(blockPos = new BlockPos((Vec3i)pos.m_7637_(-object.heatRange() + (double)object.random.m_188503_(Mth.m_14107_((double)(object.heatRange() * 2.0))), -object.heatRangeY() + (double)object.random.m_188503_(Mth.m_14107_((double)(object.heatRangeY() * 2.0))), -object.heatRange() + (double)object.random.m_188503_(Mth.m_14107_((double)(object.heatRange() * 2.0)))))).m_60795_()) {
            level.m_46597_(blockPos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)blockPos));
        }
        HeatUtils.performHeating(object, pos, level, object.heatSpeed());
    }

    @Override
    public double heatSpeed() {
        return (Double)HeatstormGeneratorCommonConfig.heat_speed.get();
    }
}

